Scriptname _SLSubmitBoundWristEffect extends ActiveMagicEffect  

Actor Property Prisoner Auto
Actor Property PlayerRef Auto
Armor Property Cuffs Auto

Event OnEffectStart(actor target, actor caster)
	Prisoner = Target
	Debug.SendAnimationEvent(Prisoner, "OffsetBoundStandingStart")
	RegisterForSingleUpdate(0.5)
EndEvent

Event OnUpdate()
	Debug.SendAnimationEvent(Prisoner, "OffsetBoundStandingStart")
	If (PlayerRef.IsOnMount() && PlayerRef.GetItemCount(Cuffs) >= 1)
		PlayerRef.Dismount()
	EndIf
	RegisterForSingleUpdate(0.5)
EndEvent

Event OnEffectFinish(actor target, actor caster)
	Debug.SendAnimationEvent(Prisoner, "IdleForceDefaultState")
EndEvent